$(document).ready(function () {
    // Theme toggle
    // const html = document.documentElement;
    // const themeBtn = $('#toggleTheme');
    // const isDark = html.getAttribute('data-theme') === 'dark';
    // themeBtn.text(isDark ? '🌞' : '🌙');

    // themeBtn.on('click', function () {
    //   const currentTheme = html.getAttribute('data-theme');
    //   const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
    //   html.setAttribute('data-theme', newTheme);
    //   themeBtn.text(newTheme === 'dark' ? '🌞' : '🌙');
    // });

    // Canvas menu toggle
    $('#openMenu').click(() => $('#mobileMenu').addClass('active'));
    $('#closeMenu').click(() => $('#mobileMenu').removeClass('active'));

    // Owl Carousel
    $(".entrepreneurs").owlCarousel({
        items: 3,
        margin: 20,
        loop: true,
        autoplay: false,
        autoplayTimeout: 3000,
        nav: true,
        dots: true,
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 2,
            },
            1000: {
                items: 3,
            }
        }
    });
});

const spot_text = document.querySelector('.spot-text');
const countElement = document.getElementById('count');

setTimeout(() => {
    countElement.textContent = 6;
}, 10000);


function get_started() {
    const getStartedBlock = document.querySelector('.get-started')
    const getStartedForm = document.querySelector('.gsf')

    getStartedBlock.style.display = 'none'
    getStartedForm.style.display = 'block'

}

document.addEventListener("DOMContentLoaded", function () {
    const steps = document.querySelectorAll(".gsf__steps__items");
    const totalSteps = steps.length;
    const stepTextCurrent = document.querySelector(".current-step");
    const stepTextTotal = document.querySelector(".total-steps");
    const backButton = document.querySelector(".gsf__back button");
    const progressBar = document.querySelector('.gsf__progress__bar')

    let currentStep = 0;

    // Initialize
    stepTextTotal.textContent = totalSteps;
    updateStep(0);

    function updateStep(index) {
        steps.forEach((step, i) => {
            step.classList.toggle("active", i === index);
        });
        stepTextCurrent.textContent = index + 1;
        backButton.style.display = index === 0 ? "none" : "flex";
    }

    window.gsf_next_step = function () {
        const activeStep = steps[currentStep];
        const selected = activeStep.querySelector("input[type='radio']:checked");
        const message = activeStep.querySelector(".gsf__steps__items__message");

        if (!selected) {
            message.style.display = "block";
            return;
        }

        message.style.display = "none";

        // ✅ If on last step
        if (currentStep === totalSteps - 1) {
            //console.log("All steps completed!");
            // 🔽 Replace with your actual final function
            onFinalStepComplete();
            return;
        }

        currentStep++;
        updateStep(currentStep);
        const progressPercent = Math.round(((currentStep + 1) / totalSteps) * 100);
        progressBar.style.setProperty('--progress', `${progressPercent}%`);
        //console.log(`Progress: ${progressPercent}%`);
    };

    window.gsf_step_back = function () {
        if (currentStep > 0) {
            currentStep--;
            updateStep(currentStep);

            //console.log(currentStep)
            const progressPercent = Math.round(((currentStep + 1) / totalSteps) * 100);
            progressBar.style.setProperty('--progress', `${progressPercent}%`);
        }
    };

    // Optional: highlight label when radio is checked
    document.querySelectorAll(".gsf__steps__items__field input[type='radio']").forEach((radio) => {
        radio.addEventListener("change", function () {
            const labels = this.closest(".gsf__steps__items__field").querySelectorAll("label");
            labels.forEach(label => label.classList.remove("checked"));
            this.closest("label").classList.add("checked");
        });
    });
});


function gsf_claim_back() {
    const claimStep = document.querySelector(".gsf__claim-store");
    const stepsBlock = document.querySelector(".gsf__steps-wrapper");
    stepsBlock.style.display = 'block'
    claimStep.style.display = 'none'
}

function onFinalStepComplete() {
    const claimStep = document.querySelector(".gsf__claim-store");
    const stepsBlock = document.querySelector(".gsf__steps-wrapper");
    stepsBlock.style.display = 'none'
    claimStep.style.display = 'flex'
}

const ksse_options = document.querySelectorAll('input[name=store_type]')
const ksse_text = document.querySelector('.ksse')
ksse_options.forEach(radio => {
    radio.addEventListener('change', function () {
        if (radio.checked) {
            // When a radio button is selected, get its value
            ksse_text.innerHTML = radio.value;
            //console.log('Selected radio button value: ' + radio.value);
        }
    });
});