<html>
<head>
    <title>storeReady - Create Shopify Store</title>

    <!-- Shopify App Bridge -->
      <script src="https://cdn.shopify.com/shopifycloud/app-bridge.js"></script>
  <script src="https://cdn.shopify.com/shopifycloud/app-bridge-utils.js"></script>
</head>
<body>
    <h1>storeReady – Shopify Store Setup</h1>

    <?php if(session('success')): ?>
        <p style="color: green;"><?php echo e(session('success')); ?></p>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <p style="color: red;"><?php echo e(session('error')); ?></p>
    <?php endif; ?>

    <form id="email-form">
        <input type="hidden" id="shop-origin" name="shop" value="<?php echo e($shopData->shopify_domain); ?>">
        <input type="email" name="email" id="owner_email" required placeholder="Enter Store Owner Email">
        <button type="submit">Submit</button>
    </form>

    <script>
    // Initialize Shopify App Bridge
    document.addEventListener("DOMContentLoaded", function () {
        const shopOrigin = document.getElementById("shop-origin").value;
        const app = window.appBridge = window["app-bridge"];

        const createApp = app.default;

        const appBridgeApp = createApp({
            apiKey: "<?php echo e(env('SHOPIFY_API_KEY')); ?>", // Laravel env variable
            shopOrigin: shopOrigin,
            host: new URLSearchParams(window.location.search).get("host"),
            forceRedirect: true
        });

        // Optional: Add TitleBar or other App Bridge actions
        const TitleBar = app.actions.TitleBar;
        TitleBar.create(appBridgeApp, {
            title: 'Shopify Dashboard'
        });
    });
    </script>

    <script>
    document.getElementById('email-form').addEventListener('submit', async function(e) {
        e.preventDefault();
    
        const formData = new FormData(this);
    
        const res = await fetch('/api/submit-email', {
            method: 'POST',
            headers: {
                'Accept': 'application/json'
            },
            body: formData
        });
    
        const data = await res.json();
    
        if (res.ok) { console.log(data);
            alert('Theme installation and metafield changes completed successfully.');
            document.getElementById("owner_email").value = "";
            
        } else {
            alert(data.error || 'Something went wrong');
        }
    });
    </script>

</body>
</html>
<?php /**PATH /home/storereadyperfor/public_html/resources/views/shopify/dashboard.blade.php ENDPATH**/ ?>