<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class ShopifyController extends Controller
{
    public function redirectToShopify(Request $request)
    {
        $shop = $request->get('shop');
        $redirectUri = route('shopify.callback');
        $scopes = 'read_customers';
        $apiKey = 'b8623cd39c2b0451e68f2e7921f9b241';

        return redirect("https://$shop/admin/oauth/authorize?client_id=$apiKey&scope=$scopes&redirect_uri=$redirectUri");
    }

    public function handleCallback(Request $request)
    {
        $params = $request->all();
        $hmac = $params['hmac'] ?? null;
        unset($params['hmac'], $params['signature']);

        // Step 1: Validate HMAC
        ksort($params);
        $queryString = http_build_query($params);
        $calculatedHmac = hash_hmac('sha256', $queryString, 'd6bc6f9b9b8cb33aa0ee35d6d5558663'); // Your Shopify App Secret

        if (!hash_equals($calculatedHmac, $hmac)) {
            abort(403, 'HMAC validation failed');
        }

        // Step 2: Get access token
        $shop = $request->get('shop');
        $code = $request->get('code');

        $response = Http::asForm()->post("https://$shop/admin/oauth/access_token", [
            'client_id' => 'b8623cd39c2b0451e68f2e7921f9b241',
            'client_secret' => 'd6bc6f9b9b8cb33aa0ee35d6d5558663', // Replace with your real secret
            'code' => $code,
        ]);

        if ($response->failed()) {
            Log::error('Failed to get access token', ['response' => $response->body()]);
            return response('OAuth failed', 500);
        }

        $data = $response->json();
        $accessToken = $data['access_token'];

        // Step 3: Save shop + access token to database (create table if not exists)
        DB::table('shops')->updateOrInsert(
            ['shop_domain' => $shop],
            ['access_token' => $accessToken, 'created_at' => now(), 'updated_at' => now()]
        );

        // Step 4: Redirect to dashboard or embedded app route
        return redirect()->route('customer-images', ['customer_id' => 123456789]);
       
    }
}

