<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ShopifyCustomerController extends Controller
{
    public function getImage(Request $request)
    {
        $customerId = $request->query('id');

        if (!$customerId) {
            return response()->json(['error' => 'Missing customer ID'], 400);
        }

        $record = DB::table('customers')
            ->where('shopify_customer_id', $customerId)
            ->first();

        if (!$record) {
            return response()->json(['image_url' => null]);
        }

        $imageUrl = url('uploads/' . $record->profile_picture); // https://your-domain.com/uploads/...
        return response()->json(['image_url' => $imageUrl]);
    }
}
