import { BlockStack, Text, Image } from "@shopify/polaris";
import { useExtensionApi, useAppQuery } from "@shopify/ui-extensions-react/admin";

export default function CustomerDetailBlock() {
    const { customer } = useExtensionApi();

    const { data, isLoading } = useAppQuery({
        url: `/api/customer-image?id=${customer.id}`,
    });

    if (isLoading) return <Text>Loading...</Text>;
    if (!data?.image_url) return <Text>No image found.</Text>;

    return (
        <BlockStack>
            <Text variant="headingMd">Customer Profile Image</Text>
            <Image source={data.image_url} alt="Customer Image" width={200} />
        </BlockStack>
    );
}
