'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var jsxRuntime = require('react/jsx-runtime');

/**
 * This component is a wrapper around the App Bridge `ui-save-bar` element.
 * It is used to display a contextual save bar to signal dirty state in the app.
 *
 * @see {@link https://shopify.dev/docs/api/app-bridge-library/react-components/save-bar}
 */
const SaveBar = /*#__PURE__*/react.forwardRef(function InternalSaveBar({
  open,
  onShow,
  onHide,
  children,
  ...rest
}, forwardedRef) {
  const [saveBar, setSaveBar] = react.useState();
  react.useEffect(() => {
    if (!saveBar) return;
    if (open) {
      saveBar.show();
    } else {
      saveBar.hide();
    }
  }, [saveBar, open]);
  react.useEffect(() => {
    if (!saveBar || !onShow) return;
    saveBar.addEventListener('show', onShow);
    return () => {
      saveBar.removeEventListener('show', onShow);
    };
  }, [saveBar, onShow]);
  react.useEffect(() => {
    if (!saveBar || !onHide) return;
    saveBar.addEventListener('hide', onHide);
    return () => {
      saveBar.removeEventListener('hide', onHide);
    };
  }, [saveBar, onHide]);
  react.useEffect(() => {
    if (!saveBar) return;
    return () => {
      saveBar.hide();
    };
  }, [saveBar]);
  return /*#__PURE__*/jsxRuntime.jsx("ui-save-bar", {
    ...rest,
    ref: saveBar => {
      setSaveBar(saveBar);
      if (forwardedRef) {
        if (typeof forwardedRef === 'function') {
          forwardedRef(saveBar);
        } else {
          forwardedRef.current = saveBar;
        }
      }
    },
    children: children
  });
});
SaveBar.displayName = 'ui-save-bar';

exports.SaveBar = SaveBar;
