import type {
  ShopifyGlobal,
  AugmentedElement,
  AppBridgeElements,
  AppBridgeAttributes,
  UIModalElement as BaseUIModalElement,
  UINavMenuElement as BaseUINavMenuElement,
  UITitleBarElement as BaseUITitleBarElement,
  UISaveBarElement as BaseUISaveBarElement,
  UIModalAttributes,
  UINavMenuAttributes,
  UITitleBarAttributes,
  UISaveBarAttributes,
  ToastOptions,
  Product,
  ProductVariant,
  Collection,
} from './shopify';

export {
  ShopifyGlobal,
  UIModalAttributes,
  UINavMenuAttributes,
  UITitleBarAttributes,
  UISaveBarAttributes,
  ToastOptions,
  Product,
  ProductVariant,
  Collection,
};

declare global {
  var shopify: ShopifyGlobal;

  // Install property augmentations onto DOM prototypes
  interface HTMLButtonElement extends AugmentedElement<'button'> {}
  interface HTMLAnchorElement extends AugmentedElement<'a'> {}

  interface UIModalElement extends BaseUIModalElement {}
  interface UINavMenuElement extends BaseUINavMenuElement {}
  interface UITitleBarElement extends BaseUITitleBarElement {}
  interface UISaveBarElement extends BaseUISaveBarElement {}

  // Install property augmentations onto ReactElement prop definitions
  namespace React {
    interface ButtonHTMLAttributes<T> extends AugmentedElement<'button'> {}
    interface AnchorHTMLAttributes<T> extends AugmentedElement<'a'> {}
  }

  // Install Element/attribute augmentations into JSX definitions
  namespace JSX {
    interface IntrinsicElements extends AppBridgeElements {}
    interface IntrinsicAttributes extends AppBridgeAttributes {}
  }
}
