import type { ClientApplication } from '../../client';
declare type FetchOperation = typeof fetch;
export interface AuthenticatedFetchOptions {
    /**
     * The fetch function to perform the network call.
     */
    fetchOperation?: FetchOperation;
    /**
     * The URL to redirect to when the session token is invalid.
     * If not provided, `requestFailureReauthorizeUrlHeader` will be used.
     */
    reauthorizeUrl?: string;
    /**
     * The Header parameter.
     */
    requestFailureReauthorizeUrlHeader: string;
}
export declare function authenticatedFetch(app: ClientApplication, fetchOperationOrOptions?: FetchOperation | AuthenticatedFetchOptions | undefined): FetchOperation;
export {};
